#include <CTBot.h>
#include <Wire.h>
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27, 16, 2);
CTBot mybot ;

String ssid = "asdfghjkl";
String pass = "qwertyuiop";

String token = "6107816512:AAHnWhn44a0ezchiNFYSW4r_BXaiF-ievPs";
const int id = 1776376270;

void setup()
{
  Serial.begin(9600);
  lcd.begin();
  lcd.backlight();
  lcd.setCursor(1, 0);
  lcd.print("ALAT PENDETEKSI");
  lcd.setCursor(4, 1);
  lcd.print("FORMALIN");
  mybot.wifiConnect(ssid, pass);
  mybot.setTelegramToken(token);
  if (mybot.testConnection())
  {
    Serial.println("Koneksi Berhasil");
  }
  else
  {
    Serial.println("Koneksi Gagal");
  }
  delay(1000);
  lcd.clear();
}

void loop() {
  float Vi = 0.65;
  float Vc = 4.95; // Constant voltage from pin
  int sensorValue = analogRead(A0); // Read analog pin for voltage info in 10 bits
  float Vf = sensorValue * 4.95 / 1023; // Voltage through pin when in presence of VOCs (formaldehyde)
  float formalin = concentrationPPMform(Vf, Vi); 
  //Serial.print("Vi: ");
  //Serial.println(sensorValue * 4.95 / 1023);
  //Serial.print("Formaldehyde Concentration: ");
  //Serial.print(concentrationPPMform(Vf, Vi));
  //Serial.print("ppm"); // Print concentration data
  //Serial.println(" "); // Print concentration data
  lcd.setCursor(0, 0);
  lcd.print("Kadar formalin");
  lcd.setCursor(0, 1);
  lcd.print("Value:");
  lcd.print(formalin);
  lcd.print(" PPM  ");
  
  if(formalin >= 5){
    String reply;
      reply = (String)"Kadar formalin saat ini tinggi\n" +
              (String)"Value: " + formalin + (String)" PPM";
      mybot.sendMessage(id, reply);
  }
  
  TBMessage msg ;
  if (mybot.getNewMessage (msg))
  {
    Serial.println("Pesan Masuk : " + msg.text);
    String pesan = msg.text;
     if (pesan == "/start")
    {
      Serial.println("Mengirim pesan ke Telegram...");
      String reply;
      reply = (String)"Selamat Datang Boss\n" +
              (String)"Masukkan pesan dibawah ini untuk monitoring.\n" +
              (String)"/formalin : untuk mengetahui kadar formalin";
      mybot.sendMessage(id, reply);
    }
    else if (pesan == "/formalin")
    {
      Serial.println("Mengirim pesan ke Telegram...");
      String reply;
      reply = (String)"Kadar formalin saat ini\n" +
              (String)"Value: " + formalin + " PPM";
      mybot.sendMessage(id, reply);
    }
  }
  delay(100); // Delay 0.5 seconds
}

float concentrationPPMform(float V, float Vstart) // Formaldehde concentration formula
{
  float con = 212.32619543773774 * exp( -( 7.653015806367451 * (4.95 - V) * Vstart ) / ( V * (4.95 - Vstart) ) );
  return con;
}
